/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet.xport.stream;

import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.tasklet.TaskletConnection;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletTerminatingException;
import com.ibm.hwmca.fw.tasklet.impl.Queue;
import com.ibm.hwmca.fw.tasklet.impl.TaskletInitialRequest;
import com.ibm.hwmca.fw.tasklet.impl.XFrameUtils;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlResponse;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.NullControlResponse;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.TerminateControlRequest;
import com.ibm.hwmca.fw.tasklet.xport.NewConnectionSource;
import com.ibm.hwmca.fw.tasklet.xport.TaskletController;
import com.ibm.hwmca.fw.tasklet.xport.TaskletManager;
import com.ibm.hwmca.fw.tasklet.xport.TaskletNewConnectionParms;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StreamPortalImpl
implements NewConnectionSource {
    private static final String TRACE_MASKT = "XTSKSSIT";
    private static final String TRACE_MASKF = "XTSKSSIF";
    private static final String TRACE_MASKD = "XTSKSSID";
    private Object lock = new Object();
    private TaskletManager manager;
    private boolean terminate = false;
    private Object connectionsLock = new Object();
    private Map connections = new HashMap();
    private boolean authenticated = false;
    private ConnectionGroup connectionGroup = null;
    private Queue taskletRequestQueue = new Queue();
    private Object rrQueueLock = new Object();
    private ObjectOutputStream dataOut = null;
    private ObjectOutputStream controlOut = null;
    private ObjectInputStream controlIn = null;
    private ObjectInputStream dataIn = null;
    private int id = -1;
    private Thread cntrlThread = null;
    private Thread driverThread = null;
    private Thread processThread = null;
    private static final String LOGON_TASKLET_CLASSNAME = "com.ibm.hwmca.base.logon.LogonTasklet";
    private static final String STARTUP_TASKLET_CLASSNAME = "com.ibm.hwmca.fw.system.StartupTasklet";
    private static final String LOGGER_TASKLET_CLASSNAME = "com.ibm.hwmca.fw.log.LoggerTasklet";

    public StreamPortalImpl(ConnectionGroup connectionGroup) throws IOException {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] <init> ");
        this.connectionGroup = connectionGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void process() {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] <xtsk:process> entry");
        this.processThread = Thread.currentThread();
        this.processThread.setName("Embryonic Tasklet Process Thread");
        try {
            this.dataOut = new ObjectOutputStream(this.connectionGroup.getConnections()[1].getSocket().getOutputStream());
            this.dataOut.flush();
            this.controlOut = new ObjectOutputStream(this.connectionGroup.getConnections()[0].getSocket().getOutputStream());
            this.controlOut.flush();
            this.controlIn = new ObjectInputStream(this.connectionGroup.getConnections()[0].getSocket().getInputStream());
            this.dataIn = new ObjectInputStream(this.connectionGroup.getConnections()[1].getSocket().getInputStream());
            this.cntrlThread = new Thread((Runnable)new ControlProcessor(this.controlIn, this.controlOut), "Embryonic Tasklet Control Thread");
            this.driverThread = new Thread((Runnable)new TaskletDriverThread(), "Embryonic Tasklet Driver Thread");
            this.cntrlThread.start();
            this.driverThread.start();
            while (!this.terminate) {
                Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] 'process' putting up read... ");
                Object theRequest = this.dataIn.readObject();
                Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] 'process' receives request :" + theRequest);
                if (theRequest instanceof ControlRequest) {
                    Trace.trace(TRACE_MASKD, "[StreamPortalImpl:" + this.id + "] out of band data seen: " + theRequest);
                    if (theRequest instanceof TerminateControlRequest) {
                        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] out of band TCR, we're out'a here.");
                        this.terminate();
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] out of band CR, posting to manager.");
                    this.manager.postControlRequest((ControlRequest)theRequest);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] 'process' posting request to driver...");
                Object object = this.rrQueueLock;
                synchronized (object) {
                    this.taskletRequestQueue.push(theRequest);
                    this.rrQueueLock.notifyAll();
                }
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] Exception in process(), done!");
            Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] " + XFrameUtils.getStackTrace(e));
            this.terminate();
        }
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] <xtsk:process> returns to caller");
    }

    public void authenticated() {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] authenticated()");
        this.authenticated = true;
        this.process();
    }

    public void unauthenticated() {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] unauthenticated()");
        this.authenticated = false;
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newConnection(Connection connection, Serializable parm) {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] newConnection( " + connection + ", " + parm + " )");
        TaskletNewConnectionParms parms = (TaskletNewConnectionParms)parm;
        Object object = this.connectionsLock;
        synchronized (object) {
            ArrayList<TaskletConnection> namedConnections = (ArrayList<TaskletConnection>)this.connections.get(parms.getName());
            if (namedConnections == null) {
                namedConnections = new ArrayList<TaskletConnection>();
                this.connections.put(parms.getName(), namedConnections);
            }
            namedConnections.add(new TaskletConnection(connection, parms.getInitData()));
            this.connectionsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskletConnection accept(String name) {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] accept( " + name + " )");
        Object theConnection = null;
        Object object = this.connectionsLock;
        synchronized (object) {
            while (!this.terminate && this.connections.get(name) == null) {
                try {
                    this.connectionsLock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (!this.terminate) {
                List namedConnections = (List)this.connections.get(name);
                TaskletConnection theNewConnection = (TaskletConnection)namedConnections.remove(0);
                if (namedConnections.isEmpty()) {
                    this.connections.remove(name);
                }
                return theNewConnection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object init(TaskletInitialRequest request) {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] init(" + request + ")");
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.manager != null) {
                    Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] Warning: init() invocation while manager exists!");
                } else {
                    this.manager = (TaskletManager)Class.forName(request.getManagerName()).newInstance();
                    this.manager.setNewConnectionSource(this);
                }
                this.lock.notifyAll();
            }
            return this.manager.init(request);
        }
        catch (TaskletTerminatingException tte) {
            Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] Tasklet appears to be terminating during init(). Flowing TaskletTerminatingException.");
            return tte;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] Error in tasklet communication layer (server side) on init(). ");
            return new TaskletException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void terminate() {
        if (!this.terminate) {
            Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] terminate()");
            Object object = this.lock;
            synchronized (object) {
                this.terminate = true;
                this.lock.notifyAll();
                if (this.manager != null) {
                    this.manager.terminate();
                } else {
                    Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] Warning: terminate() with no manager!");
                }
            }
            object = this.rrQueueLock;
            synchronized (object) {
                this.rrQueueLock.notifyAll();
            }
            try {
                this.connectionGroup.closeConnections();
            }
            catch (Exception exception) {
            }
            finally {
                this.connectionGroup = null;
            }
        }
    }

    public Object request(TaskletRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] request(" + request + ")");
        try {
            if (this.waitForManagerCreation()) {
                return this.manager.request(request);
            }
            return new TaskletException("Terminating");
        }
        catch (TaskletTerminatingException tte) {
            Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] Tasklet appears to be terminating during request(). Flowing TaskletTerminatingException.");
            throw tte;
        }
        catch (TaskletException e) {
            Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] Error in tasklet communication layer (server side) on request().");
            throw new TaskletException(e);
        }
    }

    public Object getControlRequest(ControlResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] getControlRequest(" + response + ")");
        ControlRequest cntrlRequest = null;
        cntrlRequest = this.waitForManagerCreation() ? this.manager.getControlRequest(response) : new TerminateControlRequest();
        if (cntrlRequest instanceof TerminateControlRequest) {
            this.terminate = true;
        }
        return cntrlRequest;
    }

    public Object postControlRequest(ControlRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] postControlRequest(" + request + ")");
        try {
            if (this.waitForManagerCreation()) {
                this.manager.postControlRequest(request);
                return request;
            }
            return new TaskletException("Terminating");
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] Error in tasklet communication layer (server side) on postControlRequest().");
            throw new TaskletException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForManagerCreation() {
        Object object = this.lock;
        synchronized (object) {
            while (this.manager == null && !this.terminate) {
                try {
                    Trace.trace(TRACE_MASKF, "[StreamPortalImpl:" + this.id + "] waitForManagerToExist(), waits for manager to be created.");
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return !this.terminate;
    }

    class TaskletDriverThread
    implements Runnable {
        TaskletDriverThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] <xtsk:td-thread.begins>");
            while (!StreamPortalImpl.this.terminate) {
                try {
                    Object theRequest = null;
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] predicate loop, waiting.");
                    Object object = StreamPortalImpl.this.rrQueueLock;
                    synchronized (object) {
                        theRequest = StreamPortalImpl.this.taskletRequestQueue.pull();
                        while (!StreamPortalImpl.this.terminate && theRequest == null) {
                            try {
                                StreamPortalImpl.this.rrQueueLock.wait();
                                theRequest = StreamPortalImpl.this.taskletRequestQueue.pull();
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (StreamPortalImpl.this.terminate) continue;
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] request being processed by portal : " + theRequest);
                    Object taskletResponse = null;
                    if (theRequest instanceof TaskletInitialRequest) {
                        Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] Initial request seen.");
                        Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] trace id bound from initial request.");
                        if (!StreamPortalImpl.this.authenticated && TaskletController.requiresAuthentication(((TaskletInitialRequest)theRequest).getTaskletData().getServerTaskletClass())) {
                            Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] Specified tasklet ('" + ((TaskletInitialRequest)theRequest).getTaskletData().getServerTaskletClass() + "') requires authentication, throwing UnauthorizedTaskletException.");
                            throw new UnauthorizedTaskletException(((TaskletInitialRequest)theRequest).getTaskletData().getServerTaskletClass());
                        }
                        taskletResponse = StreamPortalImpl.this.init((TaskletInitialRequest)theRequest);
                        if (taskletResponse instanceof TaskletResponse) {
                            String taskletClassName = ((TaskletInitialRequest)theRequest).getTaskletData().getServerTaskletClass() + ")";
                            StreamPortalImpl.this.id = ((TaskletResponse)taskletResponse).getTaskletId();
                            StreamPortalImpl.this.processThread.setName("Tasklet:" + StreamPortalImpl.this.id + ":process (" + taskletClassName);
                            StreamPortalImpl.this.cntrlThread.setName("Tasklet:" + StreamPortalImpl.this.id + ":control (" + taskletClassName);
                            StreamPortalImpl.this.driverThread.setName("Tasklet:" + StreamPortalImpl.this.id + ":driver (" + taskletClassName);
                        }
                    } else {
                        Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] normal request seen.");
                        taskletResponse = StreamPortalImpl.this.request((TaskletRequest)theRequest);
                    }
                    if (taskletResponse == null) {
                        Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] Unexpected 'null' response from tasklet.");
                        throw new RuntimeException("Unexpected 'null' response from tasklet.");
                    }
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] dataOut.write(): " + taskletResponse);
                    StreamPortalImpl.this.dataOut.reset();
                    StreamPortalImpl.this.dataOut.writeObject(taskletResponse);
                    StreamPortalImpl.this.dataOut.flush();
                }
                catch (TaskletTerminatingException e) {
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] TaskletTerminatingException servicing tasklet, done!");
                    StreamPortalImpl.this.terminate = true;
                }
                catch (Exception e) {
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] Exception servicing tasklet, done!");
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] " + XFrameUtils.getStackTrace(e));
                    StreamPortalImpl.this.terminate();
                }
            }
            Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":TDT] <xtsk:td-thread.ends>");
        }
    }

    class ControlProcessor
    implements Runnable {
        private ObjectInputStream controlIn = null;
        private ObjectOutputStream controlOut = null;

        ControlProcessor(ObjectInputStream controlIn, ObjectOutputStream controlOut) {
            this.controlIn = controlIn;
            this.controlOut = controlOut;
        }

        public void run() {
            Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] <xtsk:cp-thread.begins>");
            try {
                while (!StreamPortalImpl.this.terminate) {
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] controlIn.read()'ing");
                    ControlResponse resp = (ControlResponse)this.controlIn.readObject();
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] controlIn.read() got: " + resp);
                    if (resp instanceof NullControlResponse) {
                        resp = null;
                    }
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] calling getControlRequest()");
                    Object cntrlRequest = StreamPortalImpl.this.getControlRequest(resp);
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] controlOut.write()'ing: " + cntrlRequest);
                    if (cntrlRequest != null) {
                        this.controlOut.reset();
                        this.controlOut.writeObject(cntrlRequest);
                        this.controlOut.flush();
                    } else {
                        Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] 'null' control request?");
                    }
                    Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] controlOut.write() operation complete.");
                }
            }
            catch (Exception e) {
                Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] Exception, calling terminate() for processing." + "  Probably benign, closed by other side first.");
                StreamPortalImpl.this.terminate();
            }
            Trace.trace(StreamPortalImpl.TRACE_MASKF, "[StreamPortalImpl:" + StreamPortalImpl.this.id + ":CP] <xtsk:cp-thread.ends>");
        }
    }

    static class UnauthorizedTaskletException
    extends RuntimeException {
        UnauthorizedTaskletException(String msg) {
            super(msg);
        }
    }
}

